jQuery(document).ready( function($) {

	if ( $('body').find('.dipl_image_card').length > 0 ) {
		$('body').find('.dipl_image_card').each( function() {

			let thisObj = $( this ),
				wrapObj = thisObj.find( '.dipl_image_card_wrapper' );
	
			if ( 'on' === wrapObj.data( 'enable_lightbox' ) ) {
				let $orderClass = thisObj.prop('class').match(/(dipl_image_card\_[^\s]*)/)[0] + '_lightbox',
					$effect     = wrapObj.data('lightbox_effect'),
					$zoom       = 'zoom' === $effect ? true : false,
					$duration   = 'none' !== $effect ? parseInt( wrapObj.data('lightbox_transition_duration') ) : 0,
					$mainClass  = 'mfp-img-mobile dipl_image_card_lightbox ' + $orderClass + ' dipl_mfp_' + $effect,
					$prependTo  = $('body');

				if ( $('body').hasClass('et-tb-has-template') ) {
					if ( $orderClass.includes('_tb_header') ) {
						$prependTo = $('body').find('#page-container').find('#et-boc .et-l--header');
					} else if ( $orderClass.includes('_tb_body') ) {
						$prependTo = $('body').find('#page-container').find('#et-boc .et-l--body');  
					} else if ( $orderClass.includes('_tb_footer') ) {
						$prependTo = $('body').find('#page-container').find('#et-boc .et-l--footer');
					}
				}

				wrapObj.magnificPopup( {
					delegate: '.dipl_image_card_image',
					type: 'image',
					prependTo: $prependTo,
					closeOnContentClick: false,
					removalDelay: $duration,
					closeBtnInside: false,
					mainClass: $mainClass,
					callbacks: {
						elementParse: function(item) {
							item.src = item.el.attr('src');
						}
					},
					gallery: { enabled: false },
					zoom: {
						enabled: $zoom,
						duration: $duration,
						easing: 'ease-in-out',
					},
					image: {
						markup: '<div class="mfp-figure">'+
							'<div class="mfp-close"></div>'+
							'<div class="mfp-img"></div>'+
						'</div>',
						tError: '<a href="%url%">The image</a> could not be loaded.',
					},
					allowHTMLInTemplate: true
				} );
			}
		} );
	};
} ); // Document.ready.
