jQuery( document ).ready( function($) {

	if ( $( '.dipl_mystery_image' ).length > 0 ) {
		$( '.dipl_mystery_image' ).each( function() {
			const $this = $( this );
			if ( $this.find( '.dipl-mystery-image-lightbox' ).length > 0 ) {

				const $orderClass = $this.prop('class').match(/(dipl_mystery_image\_[^\s]*)/)[0] + '_lightbox';

				let $effect    = $this.find( '.dipl-mystery-image-lightbox' ).data('lightbox_effect'),
					$zoom      = 'zoom' === $effect ? true : false,
					$duration  = 'none' !== $effect ? parseInt( $this.find( '.dipl-mystery-image-lightbox' ).data( 'lightbox_transition_duration' ) ) : 0,
					$mainClass = 'mfp-img-mobile dipl_mystery_image_lightbox ' + $orderClass + ' dipl_mfp_' + $effect;

				$this.magnificPopup({
					delegate: 'a.dipl-mystery-image-lightbox',
					type: 'image',
					closeOnContentClick: false,
					closeBtnInside: false,
					mainClass: $mainClass,
					removalDelay: $duration,
					zoom: {
						enabled: $zoom,
						duration: $duration,
						easing: 'ease-in-out',
					},
					gallery: { enabled: false },
					image: {
						markup: '<div class="mfp-figure">' +
									'<div class="mfp-close"></div>' +
									'<div class="mfp-img"></div>' +
								'</div>',
						tError: '<a href="%url%">The image</a> could not be loaded.',
					},
				} );
			}
		} );
	}
} ); // Document.ready.
