jQuery( document ).ready( function($) {

	// Check if module available.
	if ( $('body').find('.dipl_posts_ticker').length > 0 ) {
		$('body').find('.dipl_posts_ticker').each( function() {
			let thisObj = $( this ),
				wrapObj = thisObj.find( '.dp-posts-ticker-wrap' );

			const $orderClass = thisObj.prop('class').match(/(dipl_posts_ticker\_[^\s]*)/)[0];

			const tickerEffect = wrapObj.data( 'ticker_effect' );

			// Scroll efffect.
			if ( 'scroll' === tickerEffect ) {
				dp_posts_ticker_set_scroll_speed( wrapObj );
			}

			// Fade effect, init swipper slider.
			if ( 'fade' === tickerEffect || 'slide' === tickerEffect ) {

				let slideAlign         = wrapObj.data( 'slide_align' );
				let autoplaySpeed      = wrapObj.data( 'fade_effect_delay' );
				let transitionDuration = wrapObj.data( 'fade_effect_transition' );
				let showArrow          = wrapObj.data( 'show_arrow' );

				let arrows = false;
				if ( 'on' === showArrow ) {
					arrows = {
						nextEl: '.' + $orderClass + ' .swiper-button-next',
						prevEl: '.' + $orderClass + ' .swiper-button-prev',
					};
				}

				let fadeEffect = false;
				if ( 'fade' === tickerEffect ) {
					fadeEffect ={ crossFade: true };
				}

				var swipperSlider = new Swiper( '.' + $orderClass + ' .swiper-container', {
					direction: slideAlign,
					slidesPerView: 1,
					slidesPerGroup: 1,
					slidesPerGroupSkip: 1,
					freeMode: true,
					autoHeight: true,
					autoplay: {
						delay: ( autoplaySpeed ) ? autoplaySpeed : 2500,
						disableOnInteraction: true
					},
					spaceBetween: 0,
					effect: tickerEffect,
					fadeEffect: fadeEffect,
					speed: ( transitionDuration ) ? transitionDuration : 700,
					loop: true,
					navigation: arrows,
					grabCursor: true,
					observer: true,
					observeParents: true,
				} );
				jQuery( '.' + $orderClass + ' .swiper-container' ).on( 'mouseleave', function(e) {
					if ( typeof swipperSlider.autoplay.start === "function" ) {
						swipperSlider.autoplay.start();
					}
				} );
				jQuery( '.' + $orderClass + ' .swiper-container' ).on( 'mouseenter', function(e) {
					if ( typeof swipperSlider.autoplay.stop === "function" ) {
						swipperSlider.autoplay.stop();
					}
				} );
			}
		} );

		$( window ).resize( function() {
			$('body').find('.dipl_posts_ticker').each( function() {
				let thisObj = $( this ),
					wrapObj = thisObj.find( '.dp-posts-ticker-wrap' );

				// Scroll efffect.
				if ( wrapObj.hasClass( 'dp-ticker-effect-scroll' ) ) {
					dp_posts_ticker_set_scroll_speed( wrapObj );
				}
			} );
		} );
	}

} ); // Document.ready.

/**
 * Set speed of ticker.
 */
function dp_posts_ticker_set_scroll_speed( wrapObj ) {
	let tickerListSize = wrapObj.find( '.dp-posts-ticker-items' ).width(),
		tickerBarSize  = wrapObj.find( '.dp-posts-ticker-bar' ).width(),
		tickerSpeed    = wrapObj.data( 'scroll_effect_delay' );

	let calcSpeed = ( ( tickerListSize + tickerBarSize ) / tickerSpeed ).toFixed( 2 );
	wrapObj.find( '.dp-posts-ticker-bar' ).css( 'animation-duration', calcSpeed + 's' );
}
