jQuery( document ).ready( function($) {

	if ( $( '.dipl_promotion_bar' ).length > 0 ) {
		$( '.dipl_promotion_bar' ).each( function() {
			const thisObj = $( this );
			const wrapObj = thisObj.find( '.dipl-promotion-bar-wrap' );

			const dateStr = wrapObj.data( 'timestamp' );
			if ( dateStr ) {
				// Update the count down every 1 second.
				let timerIntervalId = setInterval( function() {
					
					// Find the distance between now and the count down date.
					let distance = parseInt( dateStr ) - ( new Date ).getTime() / 1e3;

					// Check if days is visible.
					if ( thisObj.find( '.dipl-pb-days .dipl-pb-number' ).length > 0 ) {
						let days     = parseInt( distance / 86400 );
							days     = ( days && days > 0 ) ? days : 0;
							distance %= 86400;
							days    = ( days.toString().length < 2 ) ? "00" . concat( days ).slice( -2 ) : days;
					
						thisObj.find( '.dipl-pb-days .dipl-pb-number' ).html( days );
						if ( parseInt( days ) < 1 ) {
							thisObj.find( '.dipl-pb-days' ).addClass( 'dipl-has-zero-number' );
						} else if ( thisObj.find( '.dipl-pb-days' ).hasClass( 'dipl-has-zero-number' ) ) {
							thisObj.find( '.dipl-pb-days' ).removeClass( 'dipl-has-zero-number' );
						}
					}

					let hours    = parseInt( distance / 3600 );
						hours    = ( hours && hours > 0 ) ? hours : 0;
						distance %= 3600;
					let minutes  = parseInt( distance / 60 );
						minutes	 = ( minutes && minutes > 0 ) ? minutes : 0;
					let seconds  = parseInt( distance % 60 );
						seconds  = ( seconds && seconds > 0 ) ? seconds : 0;

					// add leading zero if number length in single digit.
					hours   = ( hours.toString().length < 2 ) ? "00" . concat( hours ).slice( -2 ) : hours;
					minutes = ( minutes.toString().length < 2 ) ? "00" . concat( minutes ).slice( -2 ) : minutes;
					seconds = ( seconds.toString().length < 2 ) ? "00" . concat( seconds ).slice( -2 ) : seconds;

					thisObj.find( '.dipl-pb-hours .dipl-pb-number' ).html( hours );
					if ( parseInt( hours ) < 1 ) {
						thisObj.find( '.dipl-pb-hours' ).addClass( 'dipl-has-zero-number' );
					} else if ( thisObj.find( '.dipl-pb-hours' ).hasClass( 'dipl-has-zero-number' ) ) {
						thisObj.find( '.dipl-pb-hours' ).removeClass( 'dipl-has-zero-number' );
					}

					thisObj.find( '.dipl-pb-minutes .dipl-pb-number' ).html( minutes );
					if ( parseInt( minutes ) < 1 ) {
						thisObj.find( '.dipl-pb-minutes' ).addClass( 'dipl-has-zero-number' );
					} else if ( thisObj.find( '.dipl-pb-minutes' ).hasClass( 'dipl-has-zero-number' ) ) {
						thisObj.find( '.dipl-pb-minutes' ).removeClass( 'dipl-has-zero-number' );
					}

					thisObj.find( '.dipl-pb-seconds .dipl-pb-number' ).html( seconds );
					if ( parseInt( seconds ) < 1 ) {
						thisObj.find( '.dipl-pb-seconds' ).addClass( 'dipl-has-zero-number' );
					} else if ( thisObj.find( '.dipl-pb-seconds' ).hasClass( 'dipl-has-zero-number' ) ) {
						thisObj.find( '.dipl-pb-seconds' ).removeClass( 'dipl-has-zero-number' );
					}

					if ( distance < 0 ) {
						thisObj.find( '.dipl-promotion-bar-timer' ).addClass( 'dipl-timer-expired' );
						clearInterval( timerIntervalId );
					}
				}, 1000 );
			}
		} );
	}
} ); // Document.ready.
